<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;

Auth::requireRole(['admin']);

$active = 'twitter_accounts';
$message = null;
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'create';

    if ($action === 'create') {
        $name = trim($_POST['name'] ?? '');
        $platform = 'twitter';
        $bearer_token = trim($_POST['bearer_token'] ?? '');
        $api_secret = trim($_POST['api_secret'] ?? '');
        $access_token = trim($_POST['access_token'] ?? '');
        $access_token_secret = trim($_POST['access_token_secret'] ?? '');

        if (!$name || !$bearer_token) {
            $error = 'الاسم و Bearer Token مطلوبان.';
        } else {
            DB::query('INSERT INTO social_accounts (user_id, platform, name, api_key, api_secret, access_token, access_token_secret, status, created_at, updated_at)
                VALUES (NULL, :platform, :name, :ak, :as, :at, :ats, "active", NOW(), NOW())', [
                'platform' => $platform,
                'name' => $name,
                'ak' => $bearer_token,
                'as' => $api_secret,
                'at' => $access_token,
                'ats' => $access_token_secret,
            ]);
            $message = 'تم إضافة الحساب بنجاح.';
        }
    } elseif ($action === 'update') {
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $bearer_token = trim($_POST['bearer_token'] ?? '');
        $api_secret = trim($_POST['api_secret'] ?? '');
        $access_token = trim($_POST['access_token'] ?? '');
        $access_token_secret = trim($_POST['access_token_secret'] ?? '');
        $status = $_POST['status'] ?? 'active';

        if ($id <= 0) {
            $error = 'معرف غير صالح.';
        } else {
            DB::query('UPDATE social_accounts 
                       SET name = :name, api_key = :ak, api_secret = :as, access_token = :at, access_token_secret = :ats, status = :st, updated_at = NOW()
                       WHERE id = :id AND platform = "twitter"', [
                'id' => $id,
                'name' => $name,
                'ak' => $bearer_token,
                'as' => $api_secret,
                'at' => $access_token,
                'ats' => $access_token_secret,
                'st' => $status,
            ]);
            $message = 'تم تحديث الحساب بنجاح.';
        }
    } elseif ($action === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id > 0) {
            DB::query('DELETE FROM social_accounts WHERE id = :id AND platform = "twitter"', ['id' => $id]);
            $message = 'تم حذف الحساب.';
        }
    }
}

$editAccount = null;
if (isset($_GET['edit_id'])) {
    $editId = (int)$_GET['edit_id'];
    $stmt = DB::query('SELECT * FROM social_accounts WHERE id = :id AND platform = "twitter" LIMIT 1', ['id' => $editId]);
    $editAccount = $stmt->fetch();
}

$accounts = DB::query("SELECT * FROM social_accounts WHERE platform = 'twitter' ORDER BY id DESC")->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>حسابات تويتر (API)</h3>
</div>

<?php if($message): ?>
  <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>
<?php if($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="card mb-4">
  <div class="card-header"><?= $editAccount ? 'تعديل حساب Twitter API' : 'إضافة حساب Twitter API' ?></div>
  <div class="card-body">
    <form method="post">
      <input type="hidden" name="action" value="<?= $editAccount ? 'update' : 'create' ?>">
      <?php if($editAccount): ?>
        <input type="hidden" name="id" value="<?= $editAccount['id'] ?>">
      <?php endif; ?>
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">اسم داخلي للحساب</label>
          <input type="text" name="name" class="form-control" required value="<?= htmlspecialchars($editAccount['name'] ?? '') ?>">
        </div>
        <div class="col-md-8">
          <label class="form-label">Bearer Token (إجباري)</label>
          <input type="text" name="bearer_token" class="form-control" required value="<?= htmlspecialchars($editAccount['api_key'] ?? '') ?>">
          <div class="form-text">ضع هنا Twitter Bearer Token الخاص بهذا الحساب.</div>
        </div>
        <div class="col-md-4">
          <label class="form-label">API Secret (اختياري)</label>
          <input type="text" name="api_secret" class="form-control" value="<?= htmlspecialchars($editAccount['api_secret'] ?? '') ?>">
        </div>
        <div class="col-md-4">
          <label class="form-label">Access Token (اختياري)</label>
          <input type="text" name="access_token" class="form-control" value="<?= htmlspecialchars($editAccount['access_token'] ?? '') ?>">
        </div>
        <div class="col-md-4">
          <label class="form-label">Access Token Secret (اختياري)</label>
          <input type="text" name="access_token_secret" class="form-control" value="<?= htmlspecialchars($editAccount['access_token_secret'] ?? '') ?>">
        </div>
        <?php if($editAccount): ?>
        <div class="col-md-4">
          <label class="form-label">الحالة</label>
          <select name="status" class="form-select">
            <option value="active" <?= $editAccount['status'] === 'active' ? 'selected' : '' ?>>نشط</option>
            <option value="inactive" <?= $editAccount['status'] === 'inactive' ? 'selected' : '' ?>>متوقف</option>
          </select>
        </div>
        <?php endif; ?>
      </div>
      <button class="btn btn-primary mt-3"><?= $editAccount ? 'تحديث' : 'حفظ' ?></button>
      <?php if($editAccount): ?>
        <a href="twitter_accounts.php" class="btn btn-secondary mt-3 ms-2">إلغاء التعديل</a>
      <?php endif; ?>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-header">القائمة</div>
  <div class="card-body p-0">
    <table class="table table-striped table-sm mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>الاسم</th>
          <th>Bearer Token</th>
          <th>الحالة</th>
          <th>خيارات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($accounts as $a): ?>
        <tr>
          <td><?= $a['id'] ?></td>
          <td><?= htmlspecialchars($a['name']) ?></td>
          <td><?= $a['api_key'] ? '*** محفوظ ***' : 'غير مضبوط' ?></td>
          <td><?= htmlspecialchars($a['status']) ?></td>
          <td>
            <a href="twitter_accounts.php?edit_id=<?= $a['id'] ?>" class="btn btn-sm btn-outline-primary">تعديل</a>
            <form method="post" class="d-inline" onsubmit="return confirm('هل تريد حذف هذا الحساب؟');">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?= $a['id'] ?>">
              <button class="btn btn-sm btn-outline-danger">حذف</button>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
