<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;

Auth::requireRole(['admin','editor']);

$active = 'rules';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $twitter_source_id = (int)($_POST['twitter_source_id'] ?? 0);
    $telegram_target_id = (int)($_POST['telegram_target_id'] ?? 0);
    $post_with_media = isset($_POST['post_with_media']) ? 1 : 0;
    $text_template = trim($_POST['text_template'] ?? '');

    DB::query('INSERT INTO publishing_rules (twitter_source_id, telegram_target_id, enabled, post_with_media, text_template, created_at, updated_at)
        VALUES (:ts, :tt, 1, :pwm, :tmpl, NOW(), NOW())', [
        'ts' => $twitter_source_id,
        'tt' => $telegram_target_id,
        'pwm' => $post_with_media,
        'tmpl' => $text_template,
    ]);

    header('Location: rules.php');
    exit;
}

$sources = DB::query("
    SELECT ts.*, sa.name AS account_name
    FROM twitter_sources ts
    INNER JOIN social_accounts sa ON sa.id = ts.social_account_id
    ORDER BY ts.id DESC
")->fetchAll();

$targets = DB::query("
    SELECT tt.*, sa.name AS bot_name
    FROM telegram_targets tt
    INNER JOIN social_accounts sa ON sa.id = tt.social_account_id
    ORDER BY tt.id DESC
")->fetchAll();

$rules = DB::query("
    SELECT pr.*, ts.display_name AS source_name, tt.display_name AS target_name
    FROM publishing_rules pr
    INNER JOIN twitter_sources ts ON ts.id = pr.twitter_source_id
    INNER JOIN telegram_targets tt ON tt.id = pr.telegram_target_id
    ORDER BY pr.id DESC
")->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>قواعد النشر (Twitter → Telegram)</h3>
</div>

<div class="card mb-4">
  <div class="card-header">إضافة قاعدة جديدة</div>
  <div class="card-body">
    <form method="post">
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">مصدر تويتر</label>
          <select name="twitter_source_id" class="form-select" required>
            <option value="">اختر...</option>
            <?php foreach ($sources as $s): ?>
              <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['display_name']) ?> (@<?= htmlspecialchars($s['identifier']) ?>)</option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">قناة / هدف تليجرام</label>
          <select name="telegram_target_id" class="form-select" required>
            <option value="">اختر...</option>
            <?php foreach ($targets as $t): ?>
              <option value="<?= $t['id'] ?>"><?= htmlspecialchars($t['display_name']) ?> (<?= htmlspecialchars($t['chat_id']) ?>)</option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-4 d-flex align-items-end">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="post_with_media" id="pwm" checked>
            <label class="form-check-label" for="pwm">
              نشر الصور إن وجدت
            </label>
          </div>
        </div>
        <div class="col-12">
          <label class="form-label">قالب النص (اختياري)</label>
          <textarea name="text_template" class="form-control" rows="3" placeholder="{text}

🔗 {url}"></textarea>
          <div class="form-text">يمكنك استخدام {text} لنص التغريدة و {url} لرابطها.</div>
        </div>
      </div>
      <button class="btn btn-primary mt-3">حفظ</button>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-header">القائمة</div>
  <div class="card-body p-0">
    <table class="table table-striped table-sm mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>المصدر</th>
          <th>الوجهة</th>
          <th>الصور</th>
          <th>الحالة</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rules as $r): ?>
        <tr>
          <td><?= $r['id'] ?></td>
          <td><?= htmlspecialchars($r['source_name']) ?></td>
          <td><?= htmlspecialchars($r['target_name']) ?></td>
          <td><?= $r['post_with_media'] ? 'نعم' : 'لا' ?></td>
          <td><?= $r['enabled'] ? 'مفعلة' : 'متوقفة' ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
