<?php
namespace App\Utils;

use App\Storage\Db;

class Logger
{
    public function __construct(private Db $db) {}

    public function info(string $context, string $message): void { $this->log('info', $context, $message); }
    public function error(string $context, string $message): void { $this->log('error', $context, $message); }

    private function log(string $level, string $context, string $message): void
    {
        $stmt = $this->db->pdo()->prepare('INSERT INTO logs (level, context, message) VALUES (?,?,?)');
        $stmt->execute([$level, $context, $message]);
    }
}
