<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/db.php';

function log_activity($action, $description = null) {
    global $mysqli;

    $user_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : null;
    $ip = $_SERVER['REMOTE_ADDR'] ?? null;
    $agent = $_SERVER['HTTP_USER_AGENT'] ?? null;

    $stmt = $mysqli->prepare("
        INSERT INTO activity_logs (user_id, action, description, ip_address, user_agent)
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->bind_param("issss", $user_id, $action, $description, $ip, $agent);
    $stmt->execute();
    $stmt->close();
}

function require_login() {
    if (empty($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
}

function current_user_role() {
    return $_SESSION['role_name'] ?? null;
}

function require_role($role) {
    require_login();
    if (current_user_role() !== $role) {
        die('ليس لديك صلاحية للوصول إلى هذه الصفحة.');
    }
}
