<?php
require_once __DIR__ . '/auth.php';
require_login();
require_once __DIR__ . '/excel_import.php';
require_once __DIR__ . '/header.php';
global $mysqli;

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_FILES['excel_file']) || $_FILES['excel_file']['error'] !== UPLOAD_ERR_OK) {
        $error = 'حدث خطأ في رفع الملف.';
    } else {
        $file = $_FILES['excel_file'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if (!in_array($ext, ['xlsx', 'xls'])) {
            $error = 'الرجاء رفع ملف Excel بامتداد xls أو xlsx.';
        } else {
            $newName = uniqid('excel_', true) . '.' . $ext;
            $targetDir = __DIR__ . '/uploads/';
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0755, true);
            }
            $targetPath = $targetDir . $newName;

            if (move_uploaded_file($file['tmp_name'], $targetPath)) {
                $user_id = (int)$_SESSION['user_id'];
                $stmt = $mysqli->prepare("
                    INSERT INTO uploaded_files (user_id, original_name, stored_name, mime_type, size, status)
                    VALUES (?, ?, ?, ?, ?, 'pending')
                ");
                $mime = $file['type'];
                $size = $file['size'];
                $stmt->bind_param("isssi", $user_id, $file['name'], $newName, $mime, $size);
                if ($stmt->execute()) {
                    $fileId = $stmt->insert_id;
                    $stmt->close();

                    // معالجة ملف الإكسل وإدخال البيانات
                    $ok = process_excel_for_file($fileId);
                    if ($ok) {
                        $message = 'تم رفع الملف ومعالجته بنجاح.';
                    } else {
                        $error = 'تم رفع الملف لكن حدثت مشكلة أثناء قراءة بيانات Excel. راجع سجل النشاطات.';
                    }
                    log_activity('file_uploaded', 'رفع ومعالجة ملف: ' . $file['name']);
                } else {
                    $error = 'خطأ في حفظ بيانات الملف: ' . $stmt->error;
                    $stmt->close();
                }
            } else {
                $error = 'تعذر نقل الملف إلى مجلد الرفع.';
            }
        }
    }
}
?>

<div class="card shadow-sm">
  <div class="card-body">
    <h4 class="mb-3">رفع ملف Excel</h4>

    <?php if ($message): ?>
      <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <?php if ($error): ?>
      <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="alert alert-info">
      <strong>مهم:</strong> هذا النموذج مهيأ لملفات التحويلات البنكية بالترتيب التالي:<br><br>
      <strong>التابة الأولى (Sheet1) باسم "التحويلات البنكية":</strong><br>
      - تحتوي على الفترة: من / إلى في صف واحد (من | تاريخ من | إلى | تاريخ إلى).<br>
      - صف إجمالي تحويل البنك (الخانة الأولى: "اجمالى تحويل البنك" والخانة الثانية: القيمة).<br>
      - صف إجمالي أوامر دفع TMS (الخانة الأولى: "اجمالى أوامر دفع TMS" والخانة الثانية: القيمة).<br>
      - صف "تحويل أعلى" وصف "تحويل أقل" بنفس الطريقة (النص في العمود الأول والقيمة في العمود الثاني).<br><br>
      <strong>التابة الثانية (Sheet2) باسم "تقرير تفاصيل التحويلات البنكية":</strong><br>
      يجب أن تحتوي على الصف الأول كعناوين للأعمدة، بالترتيب:<br>
      #، اسم المستفيد، رقم المالك، رقم السائق، نوع المالك، ايبان، أوامر دفع TMS، تحويل البنك، فرق التحويل، تاريخ التحويل، ملاحظة المستفيد، رقم الترخيص، غرض التحويل، تاريخ الإنشاء.
    </div>

    <form method="post" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label">اختر ملف Excel</label>
        <input type="file" name="excel_file" class="form-control" required>
        <div class="form-text">الملفات المسموح بها: xls, xlsx</div>
      </div>
      <button class="btn btn-primary"><i class="fa fa-upload"></i> رفع ومعالجة الملف</button>
    </form>
  </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
