-- الجداول المحدثة الخاصة بالتحويلات البنكية

DROP TABLE IF EXISTS expenses_details;
DROP TABLE IF EXISTS expenses_headers;

CREATE TABLE expenses_headers (
  id INT AUTO_INCREMENT PRIMARY KEY,
  uploaded_file_id INT NOT NULL,
  from_date DATE NULL,
  to_date DATE NULL,
  total_bank DECIMAL(18,2) DEFAULT 0,
  total_tms DECIMAL(18,2) DEFAULT 0,
  highest_diff DECIMAL(18,2) DEFAULT 0,
  lowest_diff DECIMAL(18,2) DEFAULT 0,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (uploaded_file_id) REFERENCES uploaded_files(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE expenses_details (
  id INT AUTO_INCREMENT PRIMARY KEY,
  uploaded_file_id INT NOT NULL,
  row_number INT NULL,
  beneficiary_name VARCHAR(255) NULL,
  owner_number VARCHAR(100) NULL,
  driver_number VARCHAR(100) NULL,
  owner_type VARCHAR(100) NULL,
  iban VARCHAR(50) NULL,
  tms_amount DECIMAL(18,2) DEFAULT 0,
  bank_amount DECIMAL(18,2) DEFAULT 0,
  diff_amount DECIMAL(18,2) DEFAULT 0,
  transfer_date DATE NULL,
  beneficiary_note TEXT NULL,
  license_number VARCHAR(100) NULL,
  purpose VARCHAR(255) NULL,
  created_at_excel DATE NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (uploaded_file_id) REFERENCES uploaded_files(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
