<?php
require_once __DIR__ . '/auth.php';
require_login();
require_once __DIR__ . '/header.php';
global $mysqli;

// جلب الفلاتر من GET
$from_date   = isset($_GET['from_date']) ? trim($_GET['from_date']) : '';
$to_date     = isset($_GET['to_date']) ? trim($_GET['to_date']) : '';
$beneficiary = isset($_GET['beneficiary_name']) ? trim($_GET['beneficiary_name']) : '';
$purpose     = isset($_GET['purpose']) ? trim($_GET['purpose']) : '';

// بناء شرط WHERE ديناميكي
$conditions = [];

if ($from_date !== '') {
    $conditions[] = "transfer_date >= '" . $mysqli->real_escape_string($from_date) . "'";
}
if ($to_date !== '') {
    $conditions[] = "transfer_date <= '" . $mysqli->real_escape_string($to_date) . "'";
}
if ($beneficiary !== '') {
    $conditions[] = "beneficiary_name = '" . $mysqli->real_escape_string($beneficiary) . "'";
}
if ($purpose !== '') {
    $conditions[] = "purpose = '" . $mysqli->real_escape_string($purpose) . "'";
}

$whereBase = '';
if (!empty($conditions)) {
    $whereBase = 'WHERE ' . implode(' AND ', $conditions);
}

// بيانات لمجالات الاختيار (Distinct)
$beneficiariesRes = $mysqli->query("
    SELECT DISTINCT beneficiary_name
    FROM expenses_details
    WHERE beneficiary_name IS NOT NULL AND beneficiary_name <> ''
    ORDER BY beneficiary_name
");

$purposesRes = $mysqli->query("
    SELECT DISTINCT purpose
    FROM expenses_details
    WHERE purpose IS NOT NULL AND purpose <> ''
    ORDER BY purpose
");

// ملخص حسب غرض التحويل
$whereBank = $whereBase ?: '';
if ($whereBank === '') {
    $whereBank = 'WHERE 1=1';
}
$byPurposeRes = $mysqli->query("
    SELECT purpose, SUM(bank_amount) AS total
    FROM expenses_details
    $whereBank
    GROUP BY purpose
    ORDER BY total DESC
    LIMIT 20
");

// ملخص حسب الشهر (من تاريخ التحويل)
$byMonthRes = $mysqli->query("
    SELECT DATE_FORMAT(transfer_date, '%Y-%m') AS ym, SUM(bank_amount) AS total
    FROM expenses_details
    $whereBank
    GROUP BY ym
    ORDER BY ym
");

// ملخص حسب اسم المستفيد
$byBeneficiaryRes = $mysqli->query("
    SELECT beneficiary_name, SUM(bank_amount) AS total
    FROM expenses_details
    $whereBank
    GROUP BY beneficiary_name
    ORDER BY total DESC
    LIMIT 20
");

// بيانات تفصيلية (أول 200 صف)
$detailsRes = $mysqli->query("
    SELECT *
    FROM expenses_details
    $whereBase
    ORDER BY transfer_date DESC, id DESC
    LIMIT 200
");

// تجهيز البيانات للرسوم البيانية
$purposeLabels = [];
$purposeTotals = [];
while ($row = $byPurposeRes->fetch_assoc()) {
    $purposeLabels[] = $row['purpose'] ?: 'غير محدد';
    $purposeTotals[] = (float)$row['total'];
}

$monthLabels = [];
$monthTotals = [];
while ($row = $byMonthRes->fetch_assoc()) {
    $monthLabels[] = $row['ym'] ?: 'غير محدد';
    $monthTotals[] = (float)$row['total'];
}

$benefLabels = [];
$benefTotals = [];
while ($row = $byBeneficiaryRes->fetch_assoc()) {
    $benefLabels[] = $row['beneficiary_name'] ?: 'غير محدد';
    $benefTotals[] = (float)$row['total'];
}

// إجمالي التحويلات في هذا الفلتر
$totalRes = $mysqli->query("
    SELECT SUM(bank_amount) AS s
    FROM expenses_details
    $whereBank
");
$totalRow = $totalRes->fetch_assoc();
$totalFiltered = $totalRow['s'] ?? 0;
?>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h4 class="mb-3">التقارير والتحليلات - التحويلات البنكية</h4>
    <form class="row g-3 mb-3" method="get">
      <div class="col-md-3">
        <label class="form-label">من تاريخ التحويل</label>
        <input type="date" name="from_date" value="<?= htmlspecialchars($from_date) ?>" class="form-control">
      </div>
      <div class="col-md-3">
        <label class="form-label">إلى تاريخ التحويل</label>
        <input type="date" name="to_date" value="<?= htmlspecialchars($to_date) ?>" class="form-control">
      </div>
      <div class="col-md-3">
        <label class="form-label">اسم المستفيد</label>
        <select name="beneficiary_name" class="form-select">
          <option value="">الكل</option>
          <?php while ($b = $beneficiariesRes->fetch_assoc()): ?>
            <?php $val = $b['beneficiary_name']; ?>
            <option value="<?= htmlspecialchars($val) ?>" <?= $val === $beneficiary ? 'selected' : '' ?>>
              <?= htmlspecialchars($val) ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">غرض التحويل</label>
        <select name="purpose" class="form-select">
          <option value="">الكل</option>
          <?php while ($p = $purposesRes->fetch_assoc()): ?>
            <?php $val = $p['purpose']; ?>
            <option value="<?= htmlspecialchars($val) ?>" <?= $val === $purpose ? 'selected' : '' ?>>
              <?= htmlspecialchars($val) ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-12">
        <button class="btn btn-primary"><i class="fa fa-filter"></i> تطبيق الفلاتر</button>
      </div>
    </form>

    <div class="alert alert-secondary">
      إجمالي التحويلات البنكية في النطاق المحدد: <strong><?= number_format((float)$totalFiltered, 2) ?></strong>
    </div>
  </div>
</div>

<div class="row mb-4">
  <div class="col-md-6">
    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <h5 class="card-title">ملخص حسب غرض التحويل</h5>
        <table class="table table-sm">
          <thead>
            <tr>
              <th>غرض التحويل</th>
              <th>إجمالي المبلغ (تحويل البنك)</th>
            </tr>
          </thead>
          <tbody>
            <?php for ($i = 0; $i < count($purposeLabels); $i++): ?>
              <tr>
                <td><?= htmlspecialchars($purposeLabels[$i]) ?></td>
                <td><?= number_format((float)$purposeTotals[$i], 2) ?></td>
              </tr>
            <?php endfor; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <h5 class="card-title">ملخص حسب اسم المستفيد</h5>
        <table class="table table-sm">
          <thead>
            <tr>
              <th>اسم المستفيد</th>
              <th>إجمالي المبلغ (تحويل البنك)</th>
            </tr>
          </thead>
          <tbody>
            <?php for ($i = 0; $i < count($benefLabels); $i++): ?>
              <tr>
                <td><?= htmlspecialchars($benefLabels[$i]) ?></td>
                <td><?= number_format((float)$benefTotals[$i], 2) ?></td>
              </tr>
            <?php endfor; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h5 class="card-title mb-3">الرسوم البيانية</h5>
    <div class="row">
      <div class="col-md-6 mb-4">
        <h6 class="text-center">التحويلات حسب غرض التحويل</h6>
        <canvas id="chartByPurpose" height="200"></canvas>
      </div>
      <div class="col-md-6 mb-4">
        <h6 class="text-center">التحويلات حسب الشهر</h6>
        <canvas id="chartByMonth" height="200"></canvas>
      </div>
    </div>
    <div class="row">
      <div class="col-12 mb-4">
        <h6 class="text-center">التحويلات حسب اسم المستفيد</h6>
        <canvas id="chartByBeneficiary" height="200"></canvas>
      </div>
    </div>
  </div>
</div>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h5 class="card-title mb-3">أحدث 200 عملية (وفقًا للفلاتر)</h5>
    <div class="table-responsive">
      <table class="table table-sm table-striped">
        <thead>
          <tr>
            <th>#</th>
            <th>اسم المستفيد</th>
            <th>رقم المالك</th>
            <th>رقم السائق</th>
            <th>نوع المالك</th>
            <th>IBAN</th>
            <th>مبلغ TMS</th>
            <th>مبلغ تحويل البنك</th>
            <th>فرق التحويل</th>
            <th>تاريخ التحويل</th>
            <th>ملاحظة المستفيد</th>
            <th>رقم الترخيص</th>
            <th>غرض التحويل</th>
            <th>تاريخ الإنشاء (من الملف)</th>
          </tr>
        </thead>
        <tbody>
          <?php while ($d = $detailsRes->fetch_assoc()): ?>
            <tr>
              <td><?= htmlspecialchars($d['row_number']) ?></td>
              <td><?= htmlspecialchars($d['beneficiary_name']) ?></td>
              <td><?= htmlspecialchars($d['owner_number']) ?></td>
              <td><?= htmlspecialchars($d['driver_number']) ?></td>
              <td><?= htmlspecialchars($d['owner_type']) ?></td>
              <td><?= htmlspecialchars($d['iban']) ?></td>
              <td><?= number_format((float)$d['tms_amount'], 2) ?></td>
              <td><?= number_format((float)$d['bank_amount'], 2) ?></td>
              <td><?= number_format((float)$d['diff_amount'], 2) ?></td>
              <td><?= htmlspecialchars($d['transfer_date']) ?></td>
              <td><?= htmlspecialchars($d['beneficiary_note']) ?></td>
              <td><?= htmlspecialchars($d['license_number']) ?></td>
              <td><?= htmlspecialchars($d['purpose']) ?></td>
              <td><?= htmlspecialchars($d['created_at_excel']) ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
const purposeLabels  = <?= json_encode($purposeLabels, JSON_UNESCAPED_UNICODE) ?>;
const purposeTotals  = <?= json_encode($purposeTotals) ?>;
const monthLabels = <?= json_encode($monthLabels, JSON_UNESCAPED_UNICODE) ?>;
const monthTotals = <?= json_encode($monthTotals) ?>;
const benefLabels    = <?= json_encode($benefLabels, JSON_UNESCAPED_UNICODE) ?>;
const benefTotals    = <?= json_encode($benefTotals) ?>;

if (typeof Chart !== 'undefined') {
    if (purposeLabels.length > 0) {
        new Chart(document.getElementById('chartByPurpose'), {
            type: 'pie',
            data: {
                labels: purposeLabels,
                datasets: [{
                    data: purposeTotals
                }]
            }
        });
    }

    if (monthLabels.length > 0) {
        new Chart(document.getElementById('chartByMonth'), {
            type: 'line',
            data: {
                labels: monthLabels,
                datasets: [{
                    label: 'إجمالي تحويل البنك',
                    data: monthTotals
                }]
            }
        });
    }

    if (benefLabels.length > 0) {
        new Chart(document.getElementById('chartByBeneficiary'), {
            type: 'bar',
            data: {
                labels: benefLabels,
                datasets: [{
                    label: 'إجمالي تحويل البنك',
                    data: benefTotals
                }]
            }
        });
    }
}
</script>

<?php require_once __DIR__ . '/footer.php'; ?>
