<?php
require_once __DIR__ . '/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name  = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $pass  = $_POST['password'] ?? '';

    if ($name && $email && $pass) {
        // جلب role admin
        $roleRes = $mysqli->query("SELECT id FROM roles WHERE name='admin' LIMIT 1");
        $roleRow = $roleRes->fetch_assoc();
        $role_id = $roleRow ? (int)$roleRow['id'] : 1;

        $hash = password_hash($pass, PASSWORD_BCRYPT);

        $stmt = $mysqli->prepare("INSERT INTO users (name, email, password, role_id) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("sssi", $name, $email, $hash, $role_id);
        if ($stmt->execute()) {
            $message = 'تم إنشاء المستخدم الأدمن بنجاح. يُفضّل الآن حذف ملف create_admin.php من السيرفر.';
        } else {
            $message = 'خطأ: ' . $stmt->error;
        }
        $stmt->close();
    } else {
        $message = 'الرجاء إدخال جميع البيانات.';
    }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>إنشاء أدمن</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-5">
      <div class="card shadow-sm">
        <div class="card-body">
          <h4 class="mb-3">إنشاء مستخدم أدمن</h4>
          <?php if ($message): ?>
            <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
          <?php endif; ?>
          <form method="post">
            <div class="mb-3">
              <label class="form-label">الاسم</label>
              <input type="text" name="name" class="form-control" required>
            </div>
            <div class="mb-3">
              <label class="form-label">البريد الإلكتروني</label>
              <input type="email" name="email" class="form-control" required>
            </div>
            <div class="mb-3">
              <label class="form-label">كلمة المرور</label>
              <input type="password" name="password" class="form-control" required>
            </div>
            <button class="btn btn-primary w-100">إنشاء أدمن</button>
          </form>
        </div>
      </div>
      <p class="mt-3 text-muted small">
        بعد إنشاء الأدمن وتسجيل الدخول بنجاح، قم بحذف هذا الملف (create_admin.php) من السيرفر.
      </p>
    </div>
  </div>
</div>
</body>
</html>
